<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2007-2009 Fillip Hannisdal AKA Revan/NeoRevan/Belazor # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

if (!class_exists('vB_DataManager', false))
{
	exit;
}

/**
* Class to do data save/delete operations for regions
*
* @package	vbsignatures
*/
class vBSignatures_DataManager_Region extends vB_DataManager
{
	/**
	* Array of recognised and required fields for regions, and their types
	*
	* @var	array
	*/
	var $validfields = array(
		'regionid' 				=> array(TYPE_UINT, 	REQ_INCR, 	VF_METHOD, 	'verify_nonzero'),
		'title' 				=> array(TYPE_NOHTML, 	REQ_YES, 	VF_METHOD),
		'active' 				=> array(TYPE_STR, 		REQ_NO, 	VF_METHOD, 	'verify_onoff'),
		'signaturestyleid' 		=> array(TYPE_UINT, 	REQ_YES, 	VF_METHOD),
		'xcoord' 				=> array(TYPE_UINT, 	REQ_YES, 	VF_METHOD, 	'verify_nonzero'),
		'ycoord' 				=> array(TYPE_UINT, 	REQ_YES, 	VF_METHOD, 	'verify_nonzero'),
		'stringlength' 			=> array(TYPE_UINT, 	REQ_YES, 	VF_METHOD, 	'verify_nonzero'),
		'fontid' 				=> array(TYPE_UINT, 	REQ_YES, 	VF_METHOD),
		'fontsize' 				=> array(TYPE_UINT, 	REQ_YES, 	VF_METHOD, 	'verify_nonzero'),
		'fontweight' 			=> array(TYPE_UINT, 	REQ_NO),
		'fontcolor' 			=> array(TYPE_STR, 		REQ_NO),
		'regiontext' 			=> array(TYPE_NOHTML, 	REQ_NO),
	);

	/**
	* Array of field names that are bitfields, together with the name of the variable in the registry with the definitions.
	*
	* @var	array
	*/
	//var $bitfields = array('adminpermissions' => 'bf_ugp_adminpermissions');

	/**
	* The main table this class deals with
	*
	* @var	string
	*/
	var $table = 'dbtech_vbsignatures_region';

	/**
	* Condition for update query
	*
	* @var	array
	*/
	var $condition_construct = array('regionid = %1$d', 'regionid');

	/**
	* Constructor - checks that the registry object has been passed correctly.
	*
	* @param	vB_Registry	Instance of the vBulletin data registry object - expected to have the database object as one of its $this->db member.
	* @param	integer		One of the ERRTYPE_x constants
	*/
	function vBSignatures_DataManager_Region(&$registry, $errtype = ERRTYPE_STANDARD)
	{
		parent::vB_DataManager($registry, $errtype);

		($hook = vBulletinHook::fetch_hook('dbtech_vbsignatures_regiondata_start')) ? eval($hook) : false;
	}

	/**
	* Verifies that the title is valid
	*
	* @param	string	Title of the region
	*
	* @return	boolean
	*/
	function verify_title(&$title)
	{
		global $vbphrase;
		
		$title = strval($title);
		if ($title === '')
		{
			// Invalid
			return false;
		}
		
		// Check for existing region of this name
		if ($existing = $this->registry->db->query_first("
			SELECT `title`
			FROM `" . TABLE_PREFIX . "dbtech_vbsignatures_region`
			WHERE `title` = " . $this->registry->db->sql_prepare($title) . "
				" . ($this->existing['regionid'] ? "AND `regionid` != " . $this->registry->db->sql_prepare($this->existing['regionid']) : '') . "			
			LIMIT 1
		"))
		{
			// Whoopsie, exists
			$this->error('dbtech_vbsignatures_x_already_exists_y', $vbphrase['dbtech_vbsignatures_region'], $title);
			return false;
		}
		
		return true;
	}

	/**
	* Verifies that the onoff flag is valid
	*
	* @param	string	On/Off flag
	*
	* @return	boolean
	*/
	function verify_onoff(&$onoff)
	{
		// Validate onoff
		$onoff = (!in_array($onoff, array('0', '1')) ? '1' : $onoff);
		
		return true;
	}

	/**
	* Verifies that the styleid is valid
	*
	* @param	string	styleid
	*
	* @return	boolean
	*/
	function verify_signaturestyleid(&$signaturestyleid)
	{
		// Validate speciesid
		return is_array(VBSIGNATURES::$cache['signaturestyle'][$signaturestyleid]);
	}

	/**
	* Verifies that the fontid is valid
	*
	* @param	string	fontid
	*
	* @return	boolean
	*/
	function verify_fontid(&$fontid)
	{
		// Validate speciesid
		return is_array(VBSIGNATURES::$cache['font'][$fontid]);
	}

	/**
	* Any checks to run immediately before saving. If returning false, the save will not take place.
	*
	* @param	boolean	Do the query?
	*
	* @return	boolean	True on success; false if an error occurred
	*/
	function pre_save($doquery = true)
	{
		if ($this->presave_called !== null)
		{
			return $this->presave_called;
		}

		$return_value = true;
		($hook = vBulletinHook::fetch_hook('dbtech_vbsignatures_regiondata_presave')) ? eval($hook) : false;

		$this->presave_called = $return_value;
		return $return_value;
	}
	
	/**
	* Additional data to update before a delete call (such as denormalized values in other tables).
	*
	* @param	boolean	Do the query?
	*/
	function pre_delete($doquery = true)
	{
		
		$return_value = true;
		($hook = vBulletinHook::fetch_hook('dbtech_vbsignatures_regiondata_predelete')) ? eval($hook) : false;

		$this->presave_called = $return_value;
		return $return_value;
	}

	/**
	* Additional data to update after a save call (such as denormalized values in other tables).
	* In batch updates, is executed for each record updated.
	*
	* @param	boolean	Do the query?
	*/
	function post_save_each($doquery = true)
	{
		($hook = vBulletinHook::fetch_hook('dbtech_vbsignatures_regiondata_postsave')) ? eval($hook) : false;

		// Rebuild the cache
		VBSIGNATURES_CACHE::build_cache('region', '
			LEFT JOIN ' . TABLE_PREFIX . 'dbtech_vbsignatures_signaturestyle AS style ON (style.signaturestyleid = dbtech_vbsignatures_region.signaturestyleid)
			ORDER BY style.displayorder ASC
		');

		return true;
	}

	/**
	* Additional data to update after a delete call (such as denormalized values in other tables).
	*
	* @param	boolean	Do the query?
	*/
	function post_delete($doquery = true)
	{
		($hook = vBulletinHook::fetch_hook('dbtech_vbsignatures_regiondata_delete')) ? eval($hook) : false;
		
		// Rebuild the cache
		VBSIGNATURES_CACHE::build_cache('region', '
			LEFT JOIN ' . TABLE_PREFIX . 'dbtech_vbsignatures_signaturestyle AS style ON (style.signaturestyleid = dbtech_vbsignatures_region.signaturestyleid)
			ORDER BY style.displayorder ASC
		');
		
		return true;
	}
}


/*======================================================================*\
|| ####################################################################
|| # Created: 16:52, Sat Dec 26th 2009
|| # SVN: $ $Rev$ $ - $ $Date$ $
|| ####################################################################
\*======================================================================*/